<?php

if ( ! class_exists( 'GP_Video' ) ) {

	class GP_Video {

		public function __construct() {
			add_action( 'init', array( &$this, 'gp_post_type_video' ) );		
			add_action( 'gp_videos_add_form_fields', array( &$this, 'gp_add_tax_fields' ) );		
			add_action( 'created_gp_videos', array( &$this, 'gp_save_tax_fields' ) );		
			add_action( 'gp_videos_edit_form_fields', array( &$this, 'gp_edit_tax_fields' ) );		
			add_action( 'edited_gp_videos', array( &$this, 'gp_save_tax_fields' ) );
		}
			
		public function gp_post_type_video() {
		
			global $gp;

			/*--------------------------------------------------------------
			Videos Categories Taxonomy
			--------------------------------------------------------------*/
			
			register_taxonomy( 'gp_videos', 'post', array( 
				'labels' => array( 
					'name' => __( 'Video Categories', 'gp_lang' ),
					'singular_name' => __( 'Video Category', 'gp_lang' ),
					'all_items' => __( 'All Video Categories', 'gp_lang' ),
					'add_new' => _x( 'Add New', 'video', 'gp_lang' ),
					'add_new_item' => __( 'Add New Video Category', 'gp_lang' ),
					'edit_item' => __( 'Edit Video Category', 'gp_lang' ),
					'new_item' => __( 'New Video Category', 'gp_lang' ),
					'view_item' => __( 'View Video Category', 'gp_lang' ),
					'search_items' => __( 'Search Video Categories', 'gp_lang' ),
					'menu_name' => __( 'Video Categories', 'gp_lang' )
				 ),
				'show_in_nav_menus' => true,
				'hierarchical' => true,
				'show_admin_column' => true,
				'rewrite' => array( 'slug' => $gp['video_cat_slug'] )
			 ) );

			register_taxonomy_for_object_type( 'gp_videos', 'post' );

		}
		
		
		/*--------------------------------------------------------------
		Video Category Options
		--------------------------------------------------------------*/

		public function gp_add_tax_fields( $tag ) {
		
			if ( isset( $tag->term_id ) ) {
				$t_id = $tag->term_id;	
				$term_meta = get_option( "taxonomy_$t_id" );
			} else {
				$term_meta = null;
			} ?>

			<div class="form-field">

				<label for="category-bg-image"><?php _e( 'Background Image', 'gp_lang' ); ?></label>

				<input type="text" id="term_meta" name="term_meta[bg_image]" value="<?php echo $term_meta['bg_image'] ? $term_meta['bg_image'] : ''; ?>" />
		
				<p class="description"><?php _e( 'The background of the page title. <strong>Enter an image URL that must be uploaded to the Media Library.</strong>', 'gp_lang' ); ?></p>

			</div>
			
		<?php }

		public function gp_edit_tax_fields( $tag ) {

			$t_id = $tag->term_id;
			$term_meta = get_option( "taxonomy_$t_id" ); ?>

			<tr class="form-field">

				<th scope="row" valign="top">
					<label for="category-bg-image"><?php _e( 'Background Image', 'gp_lang' ); ?></label>
				</th>

				<td>

					<input type="text" id="term_meta" name="term_meta[bg_image]" value="<?php echo $term_meta['bg_image'] ? $term_meta['bg_image'] : ''; ?>" />
			
					<p class="description"><?php _e( 'The background of the large header page title. <strong>Enter an image URL that must be uploaded to the Media Library.</strong>', 'gp_lang' ); ?></p>

				</td>

			</tr>
			
		<?php }
 
		public function gp_save_tax_fields( $term_id ) {
			if ( isset( $_POST['term_meta'] ) ) {
				$t_id = $term_id;
				$term_meta = get_option( "taxonomy_$t_id" );
				$cat_keys = array_keys( $_POST['term_meta'] );
					foreach ( $cat_keys as $key ) {
					if ( isset( $_POST['term_meta'][$key] ) ) {
						$term_meta[$key] = $_POST['term_meta'][$key];
					}
				}
				update_option( "taxonomy_$t_id", $term_meta );
			}
		}

	}

}

?>