<?php 

if ( ! class_exists( 'GP_User_Review' ) ) {

	class GP_User_Review {

		public function __construct() {
			add_action( 'init', array( &$this, 'gp_post_type_user_review' ) );
		}

		public function gp_post_type_user_review() {

			/*--------------------------------------------------------------
			User Review Post Type
			--------------------------------------------------------------*/	
	
			register_post_type( 'gp_user_review', array( 
				'labels' => array( 
					'name' => __( 'User Reviews', 'gp_lang' ),
					'singular_name' => __( 'User Review', 'gp_lang' ),
					'menu_name' => __( 'User Reviews', 'gp_lang' ),
					'all_items' => __( 'All User Reviews', 'gp_lang' ),
					'add_new' => _x( 'Add New', 'portfolio', 'gp_lang' ),
					'add_new_item' => __( 'Add New User Review', 'gp_lang' ),
					'edit_item' => __( 'Edit User Review', 'gp_lang' ),
					'new_item' => __( 'New User Review', 'gp_lang' ),
					'view_item' => __( 'View User Review', 'gp_lang' ),
					'search_items' => __( 'Search User Reviews', 'gp_lang' ),
					'not_found' => __( 'No user reviews found', 'gp_lang' ),
					'not_found_in_trash' => __( 'No user reviews found in Trash', 'gp_lang' ),
				 ),
				'public' => true,
				'exclude_from_search' => false,
				'show_ui' => true,
				'show_in_nav_menus' => true,
				'_builtin' => false,
				'_edit_link' => 'post.php?post=%d',
				'capability_type' => 'post',
				'hierarchical' => false,
				'rewrite' => array( 'slug' => 'user-review' ),
				'menu_position' => 20,
				'with_front' => true,
				'has_archive' => false,
				'supports' => array( 'title', 'thumbnail', 'editor', 'author', 'comments', 'custom-fields' )
			 ) );
		
		}
				
	}

}

?>