<?php

if ( ! class_exists( 'GP_Portfolio' ) ) {

	class GP_Portfolio {

		public function __construct() {
			add_action( 'init', array( &$this, 'gp_post_type_portfolio' ) );	
			add_action( 'manage_posts_custom_column',  array( &$this, 'gp_portfolio_custom_columns' ) );
			add_action( 'gp_portfolios_add_form_fields', array( &$this, 'gp_add_tax_fields' ) );		
			add_action( 'created_gp_portfolios', array( &$this, 'gp_save_tax_fields' ) );		
			add_action( 'gp_portfolios_edit_form_fields', array( &$this, 'gp_edit_tax_fields' ) );		
			add_action( 'edited_gp_portfolios', array( &$this, 'gp_save_tax_fields' ) );			
		}

		public function gp_post_type_portfolio() {
		
			global $gp;

			/*--------------------------------------------------------------
			Portfolio Item Post Type
			--------------------------------------------------------------*/	
	
			register_post_type( 'gp_portfolio_item', array( 
				'labels' => array( 
					'name' => __( 'Portfolio Items', 'gp_lang' ),
					'singular_name' => __( 'Portfolio Item', 'gp_lang' ),
					'menu_name' => __( 'Portfolio Items', 'gp_lang' ),
					'all_items' => __( 'All Portfolio Items', 'gp_lang' ),
					'add_new' => _x( 'Add New', 'portfolio', 'gp_lang' ),
					'add_new_item' => __( 'Add New Portfolio Item', 'gp_lang' ),
					'edit_item' => __( 'Edit Portfolio Item', 'gp_lang' ),
					'new_item' => __( 'New Portfolio Item', 'gp_lang' ),
					'view_item' => __( 'View Portfolio Item', 'gp_lang' ),
					'search_items' => __( 'Search Portfolio Items', 'gp_lang' ),
					'not_found' => __( 'No portfolio items found', 'gp_lang' ),
					'not_found_in_trash' => __( 'No portfolio items found in Trash', 'gp_lang' ),
				 ),
				'public' => true,
				'exclude_from_search' => false,
				'show_ui' => true,
				'show_in_nav_menus' => true,
				'_builtin' => false,
				'_edit_link' => 'post.php?post=%d',
				'capability_type' => 'post',
				'hierarchical' => false,
				'rewrite' => array( 'slug' => $gp['portfolio_item_slug'] ),
				'menu_position' => 20,
				'with_front' => true,
				'taxonomies' => array( 'post_tag' ),
				'has_archive' => $gp['portfolio_cat_slug'],
				'supports' => array( 'title', 'thumbnail', 'editor', 'author', 'comments', 'custom-fields' )
			 ) );
	
	
			/*--------------------------------------------------------------
			Portfolio Categories Taxonomy
			--------------------------------------------------------------*/
			
			register_taxonomy( 'gp_portfolios', 'gp_portfolio_item', array( 
				'labels' => array( 
					'name' => __( 'Portfolio Categories', 'gp_lang' ),
					'singular_name' => __( 'Portfolio Category', 'gp_lang' ),
					'all_items' => __( 'All Portfolio Categories', 'gp_lang' ),
					'add_new' => _x( 'Add New', 'portfolio', 'gp_lang' ),
					'add_new_item' => __( 'Add New Portfolio Category', 'gp_lang' ),
					'edit_item' => __( 'Edit Portfolio Category', 'gp_lang' ),
					'new_item' => __( 'New Portfolio Category', 'gp_lang' ),
					'view_item' => __( 'View Portfolio Category', 'gp_lang' ),
					'search_items' => __( 'Search Portfolio Categories', 'gp_lang' ),
					'menu_name' => __( 'Portfolio Categories', 'gp_lang' )
				 ),
				'show_in_nav_menus' => true,
				'hierarchical' => true,
				'rewrite' => array( 'slug' => $gp['portfolio_cat_slug'] )
			 ) );


			register_taxonomy_for_object_type( 'gp_portfolios', 'gp_portfolio_item' );


			/*--------------------------------------------------------------
			Portfolio Item Admin Columns
			--------------------------------------------------------------*/

			function gp_portfolio_item_edit_columns( $columns ) {
				$columns = array( 
				'cb'                   => '<input type="checkbox" />',
				'title'                => __( 'Title', 'gp_lang' ),	
				'portfolio_categories' => __( 'Categories', 'gp_lang' ),
				'portfolio_image'      => __( 'Image', 'gp_lang' ),				
				'date'                 => __( 'Date', 'gp_lang' )
				 );
				return $columns;
			}	
			add_filter( 'manage_edit-gp_portfolio_item_columns', 'gp_portfolio_item_edit_columns' );
		
		}

		public function gp_portfolio_custom_columns( $column ) {
			switch ( $column ) {
				case 'portfolio_categories':
					echo get_the_term_list( get_the_ID(), 'gp_portfolios', '', ', ', '' );
				break;
				case 'portfolio_image':
					if ( has_post_thumbnail() ) {
						the_post_thumbnail( array( 50, 50 ) );
					}
				break;					
			}
		}

		/*--------------------------------------------------------------
		Portfolio Category Options
		--------------------------------------------------------------*/

		public function gp_add_tax_fields( $tag ) {
		
			if ( isset( $tag->term_id ) ) {
				$t_id = $tag->term_id;	
				$term_meta = get_option( "taxonomy_$t_id" );
			} else {
				$term_meta = null;
			} ?>

			<div class="form-field">

				<label for="category-bg-image"><?php _e( 'Background Image', 'gp_lang' ); ?></label>

				<input type="text" id="term_meta" name="term_meta[bg_image]" value="<?php echo $term_meta['bg_image'] ? $term_meta['bg_image'] : ''; ?>" />
		
				<p class="description"><?php _e( 'The background of the page title. <strong>Enter an image URL that must be uploaded to the Media Library.</strong>', 'gp_lang' ); ?></p>

			</div>
			
		<?php }

		public function gp_edit_tax_fields( $tag ) {

			$t_id = $tag->term_id;
			$term_meta = get_option( "taxonomy_$t_id" ); ?>

			<tr class="form-field">

				<th scope="row" valign="top">
					<label for="category-bg-image"><?php _e( 'Background Image', 'gp_lang' ); ?></label>
				</th>

				<td>

					<input type="text" id="term_meta" name="term_meta[bg_image]" value="<?php echo $term_meta['bg_image'] ? $term_meta['bg_image'] : ''; ?>" />
			
					<p class="description"><?php _e( 'The background of the large header page title. <strong>Enter an image URL that must be uploaded to the Media Library.</strong>', 'gp_lang' ); ?></p>

				</td>

			</tr>
			
		<?php }
 
		public function gp_save_tax_fields( $term_id ) {
			if ( isset( $_POST['term_meta'] ) ) {
				$t_id = $term_id;
				$term_meta = get_option( "taxonomy_$t_id" );
				$cat_keys = array_keys( $_POST['term_meta'] );
					foreach ( $cat_keys as $key ) {
					if ( isset( $_POST['term_meta'][$key] ) ) {
						$term_meta[$key] = $_POST['term_meta'][$key];
					}
				}
				update_option( "taxonomy_$t_id", $term_meta );
			}
		}		
		
	}

}

?>