<?php

if ( ! class_exists( 'GP_Hub' ) ) {

	class GP_Hub {

		public function __construct() {
			add_action( 'init', array( &$this, 'gp_post_type_hub' ) );		
			add_action( 'admin_enqueue_scripts', array( &$this, 'gp_cat_scripts' ) );		
			add_action( 'gp_hubs_add_form_fields', array( &$this, 'gp_add_tax_fields' ) );		
			add_action( 'created_gp_hubs', array( &$this, 'gp_save_tax_fields' ) );		
			add_action( 'gp_hubs_edit_form_fields', array( &$this, 'gp_edit_tax_fields' ) );		
			add_action( 'edited_gp_hubs', array( &$this, 'gp_save_tax_fields' ) );
		}
			
		public function gp_post_type_hub() {
		
			global $gp;

			/*--------------------------------------------------------------
			Hub Categories Taxonomy
			--------------------------------------------------------------*/
			
			register_taxonomy( 'gp_hubs', 'page', array( 
				'labels' => array( 
					'name' => __( 'Hub Categories', 'gp_lang' ),
					'singular_name' => __( 'Hub Category', 'gp_lang' ),
					'all_items' => __( 'All Hub Categories', 'gp_lang' ),
					'add_new' => _x( 'Add New', 'hub', 'gp_lang' ),
					'add_new_item' => __( 'Add New Hub Category', 'gp_lang' ),
					'edit_item' => __( 'Edit Hub Category', 'gp_lang' ),
					'new_item' => __( 'New Hub Category', 'gp_lang' ),
					'view_item' => __( 'View Hub Category', 'gp_lang' ),
					'search_items' => __( 'Search Hub Categories', 'gp_lang' ),
					'menu_name' => __( 'Hub Categories', 'gp_lang' )
				 ),
				'show_in_nav_menus' => true,
				'hierarchical' => true,
				'show_admin_column' => true,
				'rewrite' => array( 'slug' => $gp['hub_cat_slug'] )
			 ) );

			register_taxonomy_for_object_type( 'gp_hubs', 'page' );


			/*--------------------------------------------------------------
			Hub Field Taxonomies
			--------------------------------------------------------------*/
			
			if ( !empty( $gp['hub_fields'] ) ) {
			
				foreach( $gp['hub_fields'] as $gp_hub_field ) {

					$gp_hub_field_slug = strtolower( $gp_hub_field );
					$gp_hub_field_slug = preg_replace( '/\s+/', '-', $gp_hub_field_slug );

					register_taxonomy( $gp_hub_field_slug, 'page', array(
						'labels' => array(
							'name' => $gp_hub_field,
							'singular_name' => $gp_hub_field,
							'all_items' => __( 'All ', 'gp_lang' ) . $gp_hub_field,
							'add_new' => _x( 'Add New', 'hub', 'gp_lang' ),
							'add_new' => _x( 'Add New', 'hub', 'gp_lang' ),
							'add_new_item' => __( 'Add New ', 'gp_lang' ) . $gp_hub_field,
							'edit_item' => __( 'Edit ', 'gp_lang' ) . $gp_hub_field,
							'new_item' => __( 'New ', 'gp_lang' ) . $gp_hub_field,
							'view_item' => __( 'View ', 'gp_lang' ) . $gp_hub_field,
							'search_items' => __( 'Search ', 'gp_lang' ) . $gp_hub_field,
							'menu_name' => $gp_hub_field,
						),
					) );
					
					register_taxonomy_for_object_type( $gp_hub_field_slug, 'page' );
	
				}
				
			}

		}
		
		
		/*--------------------------------------------------------------
		Hub Category Options
		--------------------------------------------------------------*/

		public function gp_cat_scripts() {	
			global $pagenow;
			if ( is_admin() && $pagenow == 'edit-tags.php' ) {
				wp_enqueue_style( 'wp-color-picker' );
				wp_enqueue_script( 'wp-color-picker' );
			}
		}	

		public function gp_add_tax_fields( $tag ) {
			
			if ( isset( $tag->term_id ) ) {
				$t_id = $tag->term_id;	
				$term_meta = get_option( "taxonomy_$t_id" );
			} else {
				$term_meta = null;
			} ?>
			
			<div class="form-field">

				<label for="category-color"><?php _e( 'Color', 'gp_lang' ); ?></label>
		
				<script>
					jQuery( document ).ready( function( $ ){  
						$('#term_meta' ).wpColorPicker();
					});
				</script>

				<input type="text" id="term_meta" name="term_meta[color]" value="<?php echo $term_meta['color'] ? $term_meta['color'] : ''; ?>" />
		
				<p class="description"><?php _e( 'Select a color to associate with this category.', 'gp_lang' ); ?></p>

			</div>

			<div class="form-field">

				<label for="category-bg-image"><?php _e( 'Background Image', 'gp_lang' ); ?></label>

				<input type="text" id="term_meta" name="term_meta[bg_image]" value="<?php echo $term_meta['bg_image'] ? $term_meta['bg_image'] : ''; ?>" />
		
				<p class="description"><?php _e( 'The background of the large header page title. <strong>Enter an image URL that must be uploaded to the Media Library.</strong>', 'gp_lang' ); ?></p>

			</div>
			
		<?php }

		public function gp_edit_tax_fields( $tag ) {

			$t_id = $tag->term_id;
			$term_meta = get_option( "taxonomy_$t_id" ); ?>

			<tr class="form-field">

				<th scope="row" valign="top">
					<label for="category-color"><?php _e( 'Color', 'gp_lang' ); ?></label>
				</th>

				<td>

					<script>
						jQuery( document ).ready( function( $ ){  
							$('#term_meta' ).wpColorPicker();
						});
					</script>

					<input type="text" id="term_meta" name="term_meta[color]" value="<?php echo $term_meta['color'] ? $term_meta['color'] : ''; ?>" />
			
					<p class="description"><?php _e( 'Select a color to associate with this category.', 'gp_lang' ); ?></p>

				</td>

			</tr>

			<tr class="form-field">

				<th scope="row" valign="top">
					<label for="category-bg-image"><?php _e( 'Background Image', 'gp_lang' ); ?></label>
				</th>

				<td>

					<input type="text" id="term_meta" name="term_meta[bg_image]" value="<?php echo $term_meta['bg_image'] ? $term_meta['bg_image'] : ''; ?>" />
			
					<p class="description"><?php _e( 'The background of the page title. <strong>Enter an image URL that must be uploaded to the Media Library.</strong>', 'gp_lang' ); ?></p>

				</td>

			</tr>
			
		<?php }
 
		public function gp_save_tax_fields( $term_id ) {
			if ( isset( $_POST['term_meta'] ) ) {
				$t_id = $term_id;
				$term_meta = get_option( "taxonomy_$t_id" );
				$cat_keys = array_keys( $_POST['term_meta'] );
					foreach ( $cat_keys as $key ) {
					if ( isset( $_POST['term_meta'][$key] ) ) {
						$term_meta[$key] = $_POST['term_meta'][$key];
					}
				}
				update_option( "taxonomy_$t_id", $term_meta );
			}
		}

	}

}

?>