<?php
/*
Plugin Name: Gauge Plugin
Plugin URI: 
Description: A required plugin for the Gauge theme you purchased from ThemeForest. It includes a number of features that you can still use if you switch to another theme.
Version: 1.0.1
Author: GhostPool
Author URI: http://themeforest.net/user/GhostPool/portfolio?ref=GhostPool
License: You should have purchased a license from ThemeForest.net
*/

if ( ! class_exists( 'GP_Gauge' ) ) {

	class GP_Gauge {

		public function __construct() {

			if ( ! class_exists( 'CustomSidebars' ) ) {
				require_once( sprintf( "%s/custom-sidebars/custom-sidebars.php", dirname( __FILE__ ) ) );
			}
						
			if ( ! class_exists( 'Widget_Importer_Exporter' ) ) {
				require_once( sprintf( "%s/widget-importer-exporter/widget-importer-exporter.php", dirname( __FILE__ ) ) );
			}

			if ( ! post_type_exists( 'gp_portfolio' ) && ! class_exists( 'GP_Portfolio' ) ) {
				require_once( sprintf( "%s/post-types/portfolio-tax.php", dirname( __FILE__ ) ) );
				$GP_Portfolio = new GP_Portfolio();
			}

			if ( ! post_type_exists( 'gp_slide' ) && ! class_exists( 'GP_Slides' ) ) {
				require_once( sprintf( "%s/post-types/slide-tax.php", dirname( __FILE__ ) ) );
				$GP_Slides = new GP_Slides();
			}

			if ( ! post_type_exists( 'gp_user_review' ) && ! class_exists( 'GP_User_Review' ) ) {
				require_once( sprintf( "%s/post-types/user-review-tax.php", dirname( __FILE__ ) ) );
				$GP_User_Review = new GP_User_Review();
			}
			
			if ( ! class_exists( 'GP_Hub' ) ) {
				require_once( sprintf( "%s/post-types/hub-tax.php", dirname( __FILE__ ) ) );
				$GP_Review = new GP_Hub();
			}

			if ( ! class_exists( 'GP_Video' ) ) {
				require_once( sprintf( "%s/post-types/video-tax.php", dirname( __FILE__ ) ) );
				$GP_Review = new GP_Video();
			}
																		
		} 
		
		public static function gp_activate() {} 		
		public static function gp_deactivate() {}
		
	}
	
}

if ( class_exists( 'GP_Gauge' ) ) {

	register_activation_hook( __FILE__, array( 'GP_Gauge', 'gp_activate' ) );
	register_deactivation_hook( __FILE__, array( 'GP_Gauge', 'gp_deactivate' ) );

	$ghostpool = new GP_Gauge();

}

?>